//We wish to thank GS BALUJA from whose site we have downloaded this code.

/*Infix to Postfix Conversion :

In normal algebra we use the infix notation like a+b*c. The corresponding postfix notation is abc*+. The algorithm for the conversion is as follows :

    * Scan the Infix string from left to right.
    * Initialise an empty stack.
    * If the scannned character is an operand, add it to the Postfix string. If the scanned character is an operator and if the stack is empty Push the character to stack.
          o If the scanned character is an Operand and the stack is not empty, compare the precedence of the character with the element on top of the stack (topStack). If topStack has higher precedence over the scanned character Pop the stack else Push the scanned character to stack. Repeat this step as long as stack is not empty and topStack has precedence over the character.
      Repeat this step till all the characters are scanned.
    * (After all characters are scanned, we have to add any character that the stack may have to the Postfix string.) If stack is not empty add topStack to Postfix string and Pop the stack. Repeat this step as long as stack is not empty.
    * Return the Postfix string. */

/*takes an infix expression and converts it into an equivalent postfix expression*/

#include<iostream>
#include<stdio.h>
#include<string.h>
#include<cmath>                
using namespace std;
//declare global variables
char stack[50];
int top=-1;
void in_to_post(char infix[]);
void push (char);
char pop();
int main()
{
	char infx[25];
	printf("Enter the infix expression");  
	gets(infx);                           //user enters function             
	in_to_post(infx);
	getchar();
	return 0;
}	
void push (char symb)            //function to push an operator into the top of the stack
{
	//restrict to less than 50 operators
	if (top>=49)         //top is the topmost index of stack which is filled
	{
		printf("stack overflow");
		getchar();
		return;
	}
	else
	{
		top=top+1;            //push symbol into the next empty position
		stack[top]=symb;
	}
}
char pop()                                       //function to pop out an operator out from the top of the stack
{
	char item;
	if(top==-1)                             //stack contains symbols from index=0
	{
		printf("stack empty");
		getchar();
		return(0);
	}
	else
	{
	 	item=stack[top];                //pop out topmost element
		top--;
	}
	return(item);
}
//define precedence order for various operators using ASCII codes
int preced(char ch)
{

	if(ch==94)                              //ASCII code for ^
	{
		return(6);
	}
	else if(ch==47)                         //ASCII code for /
	{
		return(5);
	}
	else
	if(ch==42)                              //ASCII code for *
	{
		return(4);
	}
	else if(ch==45)                         //ASCII code for -
	{
		return(3);	
	}
	else if(ch==43)                        //ASCII code for +
		return(2);
 	else
		return(1);                     //any other character receives least precedence
}
void in_to_post(char infix[])
{
	int length;
	static int index=0,pos=0;         
	char symbol,temp;
	char postfix[40];
	length=strlen(infix);
	push('#');                            //use # as sentry
	while(index<length)
	{
		symbol=infix[index];
		switch(symbol)
		{
			case'(':push(symbol);         // directly push '(' to top of stack
			break;
			case')' :temp=pop();          // pop out all symbols between '(' and ')' 
			while(temp!='(')
			{
				postfix[pos]=temp;
				pos++;
				temp=pop();
			}
			break;
			case '+' :
			case '-' :
			case '*' :
			case '/' :
			case '^' :
			while (preced(stack[top])>=preced(symbol))         //push or pop symbols depending on preference order
			{
				temp=pop();
				postfix[pos]=temp;
				pos++;
			}
			push(symbol);
			break;
			default : postfix[pos++]=symbol;          //in case of non operators,add the operand to the postfix string
			break;
		}
		index++;
	}
	//pop out the remaining symbols and add them to the postfix string
	while(top>0)
	{
		temp=pop();
		postfix[pos++]=temp;
	}
	postfix[pos++]='\0';
	puts(postfix);

}

 

 
